/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.IntSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobComposter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingComposter
extends AbstractBuildingWorker {
    public static final ISettingKey<BoolSetting> PRODUCE_DIRT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "producedirt"));
    public static final ISettingKey<IntSetting> MIN = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "warehousemin"));
    private static final String COMPOSTER = "composter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_POS = "pos";
    private static final String TAG_BARRELS = "barrels";
    private final List<BlockPos> barrels = new ArrayList<BlockPos>();

    public BuildingComposter(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> this.getModuleMatching(ItemListModule.class, m -> m.getId().equals("compostables")).isItemInList(new ItemStorage((ItemStack)stack)), new Tuple((Object)Integer.MAX_VALUE, (Object)true));
    }

    public List<BlockPos> getBarrels() {
        return ImmutableList.copyOf(this.barrels);
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobComposter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return COMPOSTER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Stamina;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Athletics;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COMPOSTER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == ModBlocks.blockBarrel && !this.barrels.contains(pos)) {
            this.barrels.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT compostBinTagList = compound.func_150295_c(TAG_BARRELS, 10);
        for (int i = 0; i < compostBinTagList.size(); ++i) {
            this.barrels.add(NBTUtil.func_186861_c((CompoundNBT)compostBinTagList.func_150305_b(i).func_74775_l(TAG_POS)));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT compostBinTagList = new ListNBT();
        for (BlockPos entry : this.barrels) {
            CompoundNBT compostBinCompound = new CompoundNBT();
            compostBinCompound.func_218657_a(TAG_POS, (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            compostBinTagList.add((Object)compostBinCompound);
        }
        compound.func_218657_a(TAG_BARRELS, (INBT)compostBinTagList);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.composter;
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingComposter.COMPOSTER);
        }
    }
}

